/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.grid.handler;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.network.grid.IGrid;
import com.raoulvdberge.refinedstorage.api.network.grid.handler.IItemGridHandler;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.api.util.StackListEntry;
import com.raoulvdberge.refinedstorage.api.util.StackListResult;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.tile.grid.portable.IPortableGrid;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemGridHandlerPortable
implements IItemGridHandler {
    private final IPortableGrid portableGrid;
    private final IGrid grid;

    public ItemGridHandlerPortable(IPortableGrid portableGrid, IGrid grid) {
        this.portableGrid = portableGrid;
        this.grid = grid;
    }

    @Override
    public void onExtract(EntityPlayerMP player, ItemStack stack, int preferredSlot, int flags) {
        if (this.portableGrid.getStorage() == null || !this.grid.isActive()) {
            return;
        }
        StackListEntry<ItemStack> entry = this.portableGrid.getItemCache().getList().getEntry(stack, 3);
        if (entry != null) {
            this.onExtract(player, entry.getId(), preferredSlot, flags);
        }
    }

    @Override
    public void onExtract(EntityPlayerMP player, UUID id, int preferredSlot, int flags) {
        if (this.portableGrid.getStorage() == null || !this.grid.isActive()) {
            return;
        }
        ItemStack entry = this.portableGrid.getItemCache().getList().get((ItemStack)id);
        if (entry == null) {
            return;
        }
        long itemSize = entry.getCount();
        int maxItemSize = ((ItemStack)entry.getStack()).func_77973_b().getItemStackLimit(((ItemStack)entry.getStack()).func_77946_l());
        boolean single = (flags & 2) == 2;
        ItemStack held = player.field_71071_by.func_70445_o();
        if (single ? !held.func_190926_b() && (!API.instance().getComparer().isEqualNoQuantity((ItemStack)entry.getStack(), held) || held.func_190916_E() + 1 > held.func_77976_d()) : !player.field_71071_by.func_70445_o().func_190926_b()) {
            return;
        }
        long size = 64L;
        if ((flags & 1) == 1 && itemSize > 1L) {
            size = itemSize / 2L;
            if (size > (long)(maxItemSize / 2) && maxItemSize != 1) {
                size = maxItemSize / 2;
            }
        } else if (single) {
            size = 1L;
        }
        size = Math.min(size, (long)maxItemSize);
        this.portableGrid.getItemStorageTracker().changed((EntityPlayer)player, ((ItemStack)entry.getStack()).func_77946_l());
        StackListResult<Object> took = this.portableGrid.getItemStorage().extract((ItemStack)entry.getStack(), size, 3, Action.SIMULATE);
        if (took == null) {
            return;
        }
        if ((flags & 4) == 4) {
            IItemHandler playerInventory = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
            if (playerInventory != null) {
                ItemStack remainder;
                if (preferredSlot != -1 && (long)(remainder = playerInventory.insertItem(preferredSlot, (ItemStack)took.getFixedStack(), true)).func_190916_E() != took.getCount()) {
                    StackListResult<ItemStack> inserted = this.portableGrid.getItemStorage().extract((ItemStack)entry.getStack(), size - (long)remainder.func_190916_E(), 3, Action.PERFORM);
                    playerInventory.insertItem(preferredSlot, StackListResult.nullToEmpty(inserted), false);
                    took.setCount(remainder.func_190916_E());
                }
                if (took.getCount() > 0L && ItemHandlerHelper.insertItemStacked((IItemHandler)playerInventory, (ItemStack)took.getFixedStack(), (boolean)true).func_190926_b()) {
                    took = this.portableGrid.getItemStorage().extract((ItemStack)entry.getStack(), size, 3, Action.PERFORM);
                    ItemHandlerHelper.insertItemStacked((IItemHandler)playerInventory, (ItemStack)StackListResult.nullToEmpty(took), (boolean)false);
                }
            }
        } else {
            took = this.portableGrid.getItemStorage().extract((ItemStack)entry.getStack(), size, 3, Action.PERFORM);
            if (single && !held.func_190926_b()) {
                held.func_190917_f(1);
            } else {
                player.field_71071_by.func_70437_b(StackListResult.nullToEmpty(took));
            }
            player.func_71113_k();
        }
        this.portableGrid.drainEnergy(RS.INSTANCE.config.portableGridExtractUsage);
    }

    @Override
    @Nullable
    public ItemStack onInsert(EntityPlayerMP player, ItemStack stack, boolean single) {
        ItemStack remainder;
        if (this.portableGrid.getStorage() == null || !this.grid.isActive()) {
            return stack;
        }
        this.portableGrid.getItemStorageTracker().changed((EntityPlayer)player, stack.func_77946_l());
        if (single) {
            if (this.portableGrid.getItemStorage().insert(stack, 1L, Action.SIMULATE) == null) {
                this.portableGrid.getItemStorage().insert(stack, 1L, Action.PERFORM);
                stack.func_190918_g(1);
            }
            remainder = stack;
        } else {
            StackListResult<ItemStack> entry = this.portableGrid.getItemStorage().insert(stack, stack.func_190916_E(), Action.PERFORM);
            if (entry == null) {
                return null;
            }
            remainder = entry.getFixedStack();
        }
        this.portableGrid.drainEnergy(RS.INSTANCE.config.portableGridInsertUsage);
        return remainder;
    }

    @Override
    public void onInsertHeldItem(EntityPlayerMP player, boolean single) {
        if (player.field_71071_by.func_70445_o().func_190926_b() || this.portableGrid.getStorage() == null || !this.grid.isActive()) {
            return;
        }
        ItemStack stack = player.field_71071_by.func_70445_o();
        int size = single ? 1 : stack.func_190916_E();
        this.portableGrid.getItemStorageTracker().changed((EntityPlayer)player, stack.func_77946_l());
        if (single) {
            if (this.portableGrid.getItemStorage().insert(stack, size, Action.SIMULATE) == null) {
                this.portableGrid.getItemStorage().insert(stack, size, Action.PERFORM);
                stack.func_190918_g(size);
                if (stack.func_190916_E() == 0) {
                    player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                }
            }
        } else {
            StackListResult<ItemStack> entry = this.portableGrid.getItemStorage().insert(stack, size, Action.PERFORM);
            player.field_71071_by.func_70437_b(StackListResult.nullToEmpty(entry));
        }
        player.func_71113_k();
        this.portableGrid.drainEnergy(RS.INSTANCE.config.portableGridInsertUsage);
    }

    @Override
    public ItemStack onShiftClick(EntityPlayerMP player, ItemStack stack) {
        return StackUtils.nullToEmpty(this.onInsert(player, stack, false));
    }

    @Override
    public void onCraftingPreviewRequested(EntityPlayerMP player, UUID id, int quantity, boolean noPreview) {
    }

    @Override
    public void onCraftingRequested(EntityPlayerMP player, UUID id, int quantity) {
    }

    @Override
    public void onCraftingCancelRequested(EntityPlayerMP player, @Nullable UUID id) {
    }
}

